#!/bin/sh
# setup.sh - script to set up cp30c server

# must be root
if [ "`id -u -n`" != "root" ]
	then
	echo "You must be root or use sudo to run this script."
	exit
fi

# 
# must be executed from install directory
if [ ! -f "./cp30c.tpl" ]
	then
	echo "This script must be executed from the CirrusPrint 3.0 install directory."
	exit
fi

home=`pwd`
allyes=""
for i in "$@" ; do 
	if [ "$i" = "-yes" ]; then
		allyes="y"
	fi
done

# license agreement acknowledgment
accept=$allyes
licfile=license.txt
until [ "$accept" = "y" -o "$accept" = "Y" ]
do
	echo ""
	echo "-----------------------------------------------------------------"
	echo "By installing this product, you are agreeing to the license terms"
	echo "found in the file $licfile.  Please enter one of these options:"
	echo "  y	I agree to the terms of the license agreement."
	echo "  n	I don't agree and want to quit the installation."
	echo "  v	I want to view the license agreement."
	echo "-----------------------------------------------------------------"
	printf "%s" "Selection: "
	read accept
	
	if [ "$accept" = "n" ]; then
		exit
	fi
	
	if [ "$accept" = "v" ]; then
		more $licfile
	fi

done

script1=cp30c

# create cp30s.http based on architecture
chmod 755 cp30c.http.i64
chmod 755 cp30c.http.arm64

# copy files on new install, leave existing files alone
[ ! -f config.ini ] && cp config.ini.sds config.ini

# try Intel/AMD
if ./cp30c.http.i64 -v >/dev/null 2>&1; then
	cp -f cp30c.http.i64 cp30c.http
fi
# try ARM
if ./cp30c.http.arm64 -v >/dev/null 2>&1; then
	cp -f cp30c.http.arm64 cp30c.http
fi
if [ ! -f cp30c.http ]; then
	echo "Please install on Intel/AMD 64 or ARM 64 architecture"
	exit 1
fi

chmod 555 cp30c.http
chmod 555 cplp.sh
chmod -R 775 web 2>/dev/null

# backup current launch executable
if [ -x /usr/bin/$script1 ];then
	cp -f /usr/bin/$script1 /usr/bin/$script1.bak
	echo "Copied old /usr/bin/$script1 to $script1.bak"
fi

cat cp30c.tpl | sed -e "s+homedir+`pwd`+" >/usr/bin/$script1
echo "Created /usr/bin/$script1 executable script."
chmod 555 /usr/bin/$script1

# Create cp30c user
if ! `id cp30c >/dev/null 2>&1`; then
	shell=`which false`
	if `useradd -c "CirrusPrint 3.0 Client" -m -s "$shell" cp30c`; then
		echo "Added user cp30c"
	fi
fi

# enable user cp30c to restart itself via /etc/sudoers
if test -f /etc/sudoers; then
	if ! grep '^cp30c ' /etc/sudoers >/dev/null 2>&1; then
		printf "\n#Enable user cp30c to restart itself\n" >>/etc/sudoers
		printf "cp30c ALL=(root) NOPASSWD: /usr/bin/cp30c\n" >>/etc/sudoers
		echo "Added cp30c to /etc/sudoers to enable sudo /usr/bin/cp30c command lines"
	fi
fi

# ensure ini files are writable
chmod 666 *.ini

# ensure data path exists
[ ! -d data ] && mkdir data && chown cp30c:cp30c data

# CREATE SERVICE
service=n

if which systemctl >/dev/null 2>&1 && test -d /etc/systemd/system; then
	# systemd
	echo "Creating/updating systemd service cp30c"
	cat cp30c.service.tpl | sed -e "s+HOME+`pwd`+" >/etc/systemd/system/cp30c.service
	chmod 644 /etc/systemd/system/cp30c.service
	systemctl daemon-reload
	systemctl enable cp30c
	service=y
fi

if [ "$service" != "y" ]; then
	# chkconfig - init.d with redhat/fedora/centos
	if which chkconfig >/dev/null 2>&1; then
		echo "Creating/updating init.d service with chkconfig command"
		chkconfig --del cp30c 2>/dev/null
		cp -f init.d.script /etc/init.d/cp30c
	  chmod 755 /etc/init.d/cp30c
	  chkconfig --add cp30c
	  service=y
	fi
fi

if [ "$service" != "y" ]; then
	# update-rc.d - init.d with debian/ubuntu
	if which update-rc.d >/dev/null 2>&1; then
		echo "Creating/updating init.d service with update-rc.d command"
		update-rc.d cp30c remove 2>/dev/null
		cp -f init.d.script /etc/init.d/cp30c
	  chmod 755 /etc/init.d/cp30c
	  update-rc.d cp30c defaults 
	  service=y
	fi
fi

if [ "$service" = "n" ]; then
	echo "Unable to find systemd, chkconfig, or update-rc.d boot script handlers."
	echo "Automatic start and boot time not configured."
fi


printf "\n\nCirrusPrint Client Setup complete.\n"
printf "\nFull documentation is found online at http://cirrusprint.com\n"
